unit Unit1;

interface

uses
  inifiles,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    FontDialog1: TFontDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  FontDialog1.Font:=Label1.Font;
  if FontDialog1.Execute then
    with FontDialog1 do begin
        label1.font.color:=Font.Color;
        Label1.Font.Name:=Font.Name;
        Label1.Font.Style:=Font.Style;
        Label1.font.Size:=Font.Size;
    End;
end;

procedure TForm1.FormShow(Sender: TObject);
var
 ini:TiniFile;
begin
 ini:=TiniFile.Create('clubeDelphi.ini');

 Label1.Font.Name:=ini.ReadString('CONFIG','NAME','Arial');
 Label1.Font.color:=ini.ReadInteger('CONFIG','COLOR',0);
 Label1.Font.SIZE:=ini.ReadInteger('CONFIG','SIZE',0);

 if ini.ReadInteger('CONFIG','BOLD',0)=1 then
   Label1.Font.Style:=Label1.Font.Style+[fsBold];

 if ini.ReadInteger('CONFIG','ITALIC',0)=1 then
   Label1.Font.Style:=Label1.Font.Style+[fsItalic];

 if ini.ReadInteger('CONFIG','UNDERLINE',0)=1 then
   Label1.Font.Style:=Label1.Font.Style+[fsUnderline];

 if ini.ReadInteger('CONFIG','STRIKEOUT',0)=1 then
   Label1.Font.Style:=Label1.Font.Style+[fsStrikeOut];


 Top:=    ini.ReadInteger('FORM1','TOP',0);
 Left:=   ini.ReadInteger('FORM1','LEFT',0);
 Width:=  ini.ReadInteger('FORM1','Width',100);
 Height:= ini.ReadInteger('FORM1','Height',100);

 ini.Free;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
 ini:TiniFile;
begin
  ini:= TiniFile.Create('clubedelphi.ini');
  ini.WriteInteger('FORM1','LEFT',left);
  ini.WriteInteger('FORM1','TOP',top);
  ini.WriteInteger('FORM1','WIDTH',width);
  ini.WriteInteger('FORM1','HEIGHT',height);

  ini.WriteString('CONFIG','NAME',Label1.Font.Name);
  ini.WriteInteger('CONFIG','COLOR',Label1.font.Color);
  ini.WriteInteger('CONFIG','SIZE',Label1.Font.Size);

  if fsBold in Label1.Font.Style then
    ini.WriteInteger('CONFIG','BOLD',1)
  Else
    ini.WriteInteger('CONFIG','BOLD',0);

  if fsItalic in Label1.Font.Style then
    ini.WriteInteger('CONFIG','ITALIC',1)
  Else
    ini.WriteInteger('CONFIG','ITALIC',0);

  if fsUnderline in Label1.Font.Style then
    ini.WriteInteger('CONFIG','UNDERLINE',1)
  Else
    ini.WriteInteger('CONFIG','UNDERLINE',0);

  if fsStrikeOut in Label1.Font.Style then
    ini.WriteInteger('CONFIG','STRIKEOUT',1)
  Else
    ini.WriteInteger('CONFIG','STRIKEOUT',0);


  ini.free;

end;

end.
